//////////////////////////////////////////////////////////////////////////////
//
//  kernel.cpp - Fake Singularity ARM Kernel
//
//  Copyright Microsoft Corporation.
//
typedef int INT;
typedef char INT8, *PINT8;
typedef short INT16, *PINT16;
typedef long INT32, *PINT32;
typedef __int64 INT64, *PINT64;
typedef long LARGEST;
typedef char CHAR, *PCHAR;
typedef unsigned int UINT;
typedef unsigned char UINT8, *PUINT8;
typedef unsigned short UINT16, *PUINT16;
typedef unsigned long UINT32, *PUINT32;
typedef unsigned __int64 UINT64, *PUINT64;
typedef unsigned long ULARGEST;
typedef unsigned short WCHAR;
typedef unsigned char UCHAR;
typedef int BOOL;
typedef void *PVOID;
typedef UINT32 ULONG_PTR;
typedef UINT32 UINTPTR;

#define NULL    0
#define arrayof(a)      (sizeof(a)/sizeof(a[0]))
#define offsetof(s,m)   (size_t)&(((s *)0)->m)

//#define DEBUG 1

/////////////////////////////////////////// Core types used by runtime system.
//

extern "C" ULONG_PTR _security_cookie = 0;

typedef __wchar_t           bartok_char;

typedef signed char         int8;
typedef signed short        int16;
typedef signed int          int32;
typedef __int64             int64;

typedef unsigned int        uint;
typedef unsigned char       uint8;
typedef unsigned short      uint16;
typedef unsigned int        uint32;
typedef unsigned __int64    uint64;

typedef float               float32;
typedef double              float64;

typedef int                 intptr;
typedef unsigned int        uintptr;

struct uintPtr
{
    uintptr value;
};

struct intPtr
{
    intptr value;
};

typedef struct uintPtr *UIntPtr;
typedef struct intPtr *IntPtr;

/////////////////////////////////////////////////////////////// Static Assert.
//
// Compile-time (not run-time) assertion. Code will not compile if
// expr is false. Note: there is no non-debug version of this; we
// want this for all builds. The compiler optimizes the code away.
//
template <bool x> struct STATIC_ASSERT_FAILURE;
template <> struct STATIC_ASSERT_FAILURE<true> { };
template <int x> struct static_assert_test { };

#define STATIC_CAT_INNER(x,y) x##y
#define STATIC_CAT(x,y) STATIC_CAT_INNER(x,y)

#define STATIC_ASSERT(condition) \
   typedef static_assert_test< \
      sizeof(STATIC_ASSERT_FAILURE<(bool)(condition)>)> \
         STATIC_CAT(__static_assert_typedef_, __COUNTER__)

//////////////////////////////////////////////////////////////////////////////
//
#define OFFSETOF(s,m)   ((uintptr)&(((s *)0)->m))

//////////////////////////////////////////////////////////////////////////////
//
#pragma warning(disable: 4103)
#include "halclass.h"

//////////////////////////////////////////////////////////////////////////////

#define OMAP_CORE_CM_BASE               (0x48004A00)

#define CM_CORE_EN_UART2                (1 << 14)
#define CM_CORE_EN_UART1                (1 << 13)

#define CM_FCLKEN1_CORE                 (0)
#define CM_ICLKEN1_CORE                 (0x10)

#define OMAP_SCM_BASE                   (0x48002000)

//////////////////////////////////////////////////////////////////////////////

inline uint32 ReadReg32(volatile void * addr)
{
    return ((volatile uint32 *)addr)[0];
}

inline void WriteReg32(volatile void * addr, uint32 value)
{
    ((volatile uint32 *)addr)[0] = value;
}

inline void WriteReg8(volatile void * addr, uint8 value)
{
    ((volatile uint8 *)addr)[0] = value;
}

inline uint8 ReadReg8(volatile void * addr)
{
    return ((volatile uint8 *)addr)[0];
}

//////////////////////////////////////////////////////////////////////////////
//

typedef unsigned int uint;
typedef unsigned int UINT;
typedef signed long LARGEST;
typedef unsigned long ULARGEST;

#include "strformat.cpp"
#include "printf.cpp"
#include "debuguart.cpp"
#include "debug.cpp"

//////////////////////////////////////////////////////////////////////////////
//
void Halt(void);

#define ASSERT(b)   if (!(b)) { AssertFailed(#b);} else
void AssertFailed(const char *string)
{
    printf("Assert Failed [%s]\n", string);
    Halt();
}

////////////////////////////////////////////////////////////////////// Memory.
//
extern "C" void * memset(void *dest, uint8 c, uint count);
extern "C" void * memmove(void *dest, const void *src, uint count);

///////////////////////////////////////////////////////////// Screen Routines.
//
static uint8 Font8[] =
    {
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x7e,0x81,0xa5,0x81,0xbd,0x99,0x81,0x7e,
        0x7e,0xff,0xdb,0xff,0xc3,0xe7,0xff,0x7e,
        0x6c,0xfe,0xfe,0xfe,0x7c,0x38,0x10,0x00,
        0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,
        0x38,0x7c,0x38,0xfe,0xfe,0x7c,0x38,0x7c,
        0x10,0x10,0x38,0x7c,0xfe,0x7c,0x38,0x7c,
        0x00,0x00,0x18,0x3c,0x3c,0x18,0x00,0x00,
        0xff,0xff,0xe7,0xc3,0xc3,0xe7,0xff,0xff,
        0x00,0x3c,0x66,0x42,0x42,0x66,0x3c,0x00,
        0xff,0xc3,0x99,0xbd,0xbd,0x99,0xc3,0xff,
        0x0f,0x07,0x0f,0x7d,0xcc,0xcc,0xcc,0x78,
        0x3c,0x66,0x66,0x66,0x3c,0x18,0x7e,0x18,
        0x3f,0x33,0x3f,0x30,0x30,0x70,0xf0,0xe0,
        0x7f,0x63,0x7f,0x63,0x63,0x67,0xe6,0xc0,
        0x99,0x5a,0x3c,0xe7,0xe7,0x3c,0x5a,0x99,
        0x80,0xe0,0xf8,0xfe,0xf8,0xe0,0x80,0x00,
        0x02,0x0e,0x3e,0xfe,0x3e,0x0e,0x02,0x00,
        0x18,0x3c,0x7e,0x18,0x18,0x7e,0x3c,0x18,
        0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00,
        0x7f,0xdb,0xdb,0x7b,0x1b,0x1b,0x1b,0x00,
        0x3e,0x63,0x38,0x6c,0x6c,0x38,0xcc,0x78,
        0x00,0x00,0x00,0x00,0x7e,0x7e,0x7e,0x00,
        0x18,0x3c,0x7e,0x18,0x7e,0x3c,0x18,0xff,
        0x18,0x3c,0x7e,0x18,0x18,0x18,0x18,0x00,
        0x18,0x18,0x18,0x18,0x7e,0x3c,0x18,0x00,
        0x00,0x18,0x0c,0xfe,0x0c,0x18,0x00,0x00,
        0x00,0x30,0x60,0xfe,0x60,0x30,0x00,0x00,
        0x00,0x00,0xc0,0xc0,0xc0,0xfe,0x00,0x00,
        0x00,0x24,0x66,0xff,0x66,0x24,0x00,0x00,
        0x00,0x18,0x3c,0x7e,0xff,0xff,0x00,0x00,
        0x00,0xff,0xff,0x7e,0x3c,0x18,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x30,0x78,0x78,0x30,0x30,0x00,0x30,0x00,
        0x6c,0x6c,0x6c,0x00,0x00,0x00,0x00,0x00,
        0x6c,0x6c,0xfe,0x6c,0xfe,0x6c,0x6c,0x00,
        0x30,0x7c,0xc0,0x78,0x0c,0xf8,0x30,0x00,
        0x00,0xc6,0xcc,0x18,0x30,0x66,0xc6,0x00,
        0x38,0x6c,0x38,0x76,0xdc,0xcc,0x76,0x00,
        0x60,0x60,0xc0,0x00,0x00,0x00,0x00,0x00,
        0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00,
        0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00,
        0x00,0x66,0x3c,0xff,0x3c,0x66,0x00,0x00,
        0x00,0x30,0x30,0xfc,0x30,0x30,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60,
        0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,
        0x06,0x0c,0x18,0x30,0x60,0xc0,0x80,0x00,
        0x7c,0xc6,0xce,0xde,0xf6,0xe6,0x7c,0x00,
        0x30,0x70,0x30,0x30,0x30,0x30,0xfc,0x00,
        0x78,0xcc,0x0c,0x38,0x60,0xcc,0xfc,0x00,
        0x78,0xcc,0x0c,0x38,0x0c,0xcc,0x78,0x00,
        0x1c,0x3c,0x6c,0xcc,0xfe,0x0c,0x1e,0x00,
        0xfc,0xc0,0xf8,0x0c,0x0c,0xcc,0x78,0x00,
        0x38,0x60,0xc0,0xf8,0xcc,0xcc,0x78,0x00,
        0xfc,0xcc,0x0c,0x18,0x30,0x30,0x30,0x00,
        0x78,0xcc,0xcc,0x78,0xcc,0xcc,0x78,0x00,
        0x78,0xcc,0xcc,0x7c,0x0c,0x18,0x70,0x00,
        0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00,
        0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x60,
        0x18,0x30,0x60,0xc0,0x60,0x30,0x18,0x00,
        0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,
        0x60,0x30,0x18,0x0c,0x18,0x30,0x60,0x00,
        0x78,0xcc,0x0c,0x18,0x30,0x00,0x30,0x00,
        0x7c,0xc6,0xde,0xde,0xde,0xc0,0x78,0x00,
        0x30,0x78,0xcc,0xcc,0xfc,0xcc,0xcc,0x00,
        0xfc,0x66,0x66,0x7c,0x66,0x66,0xfc,0x00,
        0x3c,0x66,0xc0,0xc0,0xc0,0x66,0x3c,0x00,
        0xf8,0x6c,0x66,0x66,0x66,0x6c,0xf8,0x00,
        0xfe,0x62,0x68,0x78,0x68,0x62,0xfe,0x00,
        0xfe,0x62,0x68,0x78,0x68,0x60,0xf0,0x00,
        0x3c,0x66,0xc0,0xc0,0xce,0x66,0x3e,0x00,
        0xcc,0xcc,0xcc,0xfc,0xcc,0xcc,0xcc,0x00,
        0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00,
        0x1e,0x0c,0x0c,0x0c,0xcc,0xcc,0x78,0x00,
        0xe6,0x66,0x6c,0x78,0x6c,0x66,0xe6,0x00,
        0xf0,0x60,0x60,0x60,0x62,0x66,0xfe,0x00,
        0xc6,0xee,0xfe,0xfe,0xd6,0xc6,0xc6,0x00,
        0xc6,0xe6,0xf6,0xde,0xce,0xc6,0xc6,0x00,
        0x38,0x6c,0xc6,0xc6,0xc6,0x6c,0x38,0x00,
        0xfc,0x66,0x66,0x7c,0x60,0x60,0xf0,0x00,
        0x78,0xcc,0xcc,0xcc,0xdc,0x78,0x1c,0x00,
        0xfc,0x66,0x66,0x7c,0x6c,0x66,0xe6,0x00,
        0x78,0xcc,0xe0,0x70,0x1c,0xcc,0x78,0x00,
        0xfc,0xb4,0x30,0x30,0x30,0x30,0x78,0x00,
        0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xfc,0x00,
        0xcc,0xcc,0xcc,0xcc,0xcc,0x78,0x30,0x00,
        0xc6,0xc6,0xc6,0xd6,0xfe,0xee,0xc6,0x00,
        0xc6,0xc6,0x6c,0x38,0x38,0x6c,0xc6,0x00,
        0xcc,0xcc,0xcc,0x78,0x30,0x30,0x78,0x00,
        0xfe,0xc6,0x8c,0x18,0x32,0x66,0xfe,0x00,
        0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00,
        0xc0,0x60,0x30,0x18,0x0c,0x06,0x02,0x00,
        0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00,
        0x10,0x38,0x6c,0xc6,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
        0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x78,0x0c,0x7c,0xcc,0x76,0x00,
        0xe0,0x60,0x60,0x7c,0x66,0x66,0xdc,0x00,
        0x00,0x00,0x78,0xcc,0xc0,0xcc,0x78,0x00,
        0x1c,0x0c,0x0c,0x7c,0xcc,0xcc,0x76,0x00,
        0x00,0x00,0x78,0xcc,0xfc,0xc0,0x78,0x00,
        0x38,0x6c,0x60,0xf0,0x60,0x60,0xf0,0x00,
        0x00,0x00,0x76,0xcc,0xcc,0x7c,0x0c,0xf8,
        0xe0,0x60,0x6c,0x76,0x66,0x66,0xe6,0x00,
        0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00,
        0x0c,0x00,0x0c,0x0c,0x0c,0xcc,0xcc,0x78,
        0xe0,0x60,0x66,0x6c,0x78,0x6c,0xe6,0x00,
        0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00,
        0x00,0x00,0xcc,0xfe,0xfe,0xd6,0xc6,0x00,
        0x00,0x00,0xf8,0xcc,0xcc,0xcc,0xcc,0x00,
        0x00,0x00,0x78,0xcc,0xcc,0xcc,0x78,0x00,
        0x00,0x00,0xdc,0x66,0x66,0x7c,0x60,0xf0,
        0x00,0x00,0x76,0xcc,0xcc,0x7c,0x0c,0x1e,
        0x00,0x00,0xdc,0x76,0x66,0x60,0xf0,0x00,
        0x00,0x00,0x7c,0xc0,0x78,0x0c,0xf8,0x00,
        0x10,0x30,0x7c,0x30,0x30,0x34,0x18,0x00,
        0x00,0x00,0xcc,0xcc,0xcc,0xcc,0x76,0x00,
        0x00,0x00,0xcc,0xcc,0xcc,0x78,0x30,0x00,
        0x00,0x00,0xc6,0xd6,0xfe,0xfe,0x6c,0x00,
        0x00,0x00,0xc6,0x6c,0x38,0x6c,0xc6,0x00,
        0x00,0x00,0xcc,0xcc,0xcc,0x7c,0x0c,0xf8,
        0x00,0x00,0xfc,0x98,0x30,0x64,0xfc,0x00,
        0x1c,0x30,0x30,0xe0,0x30,0x30,0x1c,0x00,
        0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00,
        0xe0,0x30,0x30,0x1c,0x30,0x30,0xe0,0x00,
        0x76,0xdc,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x10,0x38,0x6c,0xc6,0xc6,0xfe,0x00,
        0x78,0xcc,0xc0,0xcc,0x78,0x18,0x0c,0x78,
        0x00,0xcc,0x00,0xcc,0xcc,0xcc,0x7e,0x00,
        0x1c,0x00,0x78,0xcc,0xfc,0xc0,0x78,0x00,
        0x7e,0xc3,0x3c,0x06,0x3e,0x66,0x3f,0x00,
        0xcc,0x00,0x78,0x0c,0x7c,0xcc,0x7e,0x00,
        0xe0,0x00,0x78,0x0c,0x7c,0xcc,0x7e,0x00,
        0x30,0x30,0x78,0x0c,0x7c,0xcc,0x7e,0x00,
        0x00,0x00,0x78,0xc0,0xc0,0x78,0x0c,0x38,
        0x7e,0xc3,0x3c,0x66,0x7e,0x60,0x3c,0x00,
        0xcc,0x00,0x78,0xcc,0xfc,0xc0,0x78,0x00,
        0xe0,0x00,0x78,0xcc,0xfc,0xc0,0x78,0x00,
        0xcc,0x00,0x70,0x30,0x30,0x30,0x78,0x00,
        0x7c,0xc6,0x38,0x18,0x18,0x18,0x3c,0x00,
        0xe0,0x00,0x70,0x30,0x30,0x30,0x78,0x00,
        0xc6,0x38,0x6c,0xc6,0xfe,0xc6,0xc6,0x00,
        0x30,0x30,0x00,0x78,0xcc,0xfc,0xcc,0x00,
        0x1c,0x00,0xfc,0x60,0x78,0x60,0xfc,0x00,
        0x00,0x00,0x7f,0x0c,0x7f,0xcc,0x7f,0x00,
        0x3e,0x6c,0xcc,0xfe,0xcc,0xcc,0xce,0x00,
        0x78,0xcc,0x00,0x78,0xcc,0xcc,0x78,0x00,
        0x00,0xcc,0x00,0x78,0xcc,0xcc,0x78,0x00,
        0x00,0xe0,0x00,0x78,0xcc,0xcc,0x78,0x00,
        0x78,0xcc,0x00,0xcc,0xcc,0xcc,0x7e,0x00,
        0x00,0xe0,0x00,0xcc,0xcc,0xcc,0x7e,0x00,
        0x00,0xcc,0x00,0xcc,0xcc,0x7c,0x0c,0xf8,
        0xc3,0x18,0x3c,0x66,0x66,0x3c,0x18,0x00,
        0xcc,0x00,0xcc,0xcc,0xcc,0xcc,0x78,0x00,
        0x18,0x18,0x7e,0xc0,0xc0,0x7e,0x18,0x18,
        0x38,0x6c,0x64,0xf0,0x60,0xe6,0xfc,0x00,
        0xcc,0xcc,0x78,0xfc,0x30,0xfc,0x30,0x30,
        0xf8,0xcc,0xcc,0xfa,0xc6,0xcf,0xc6,0xc7,
        0x0e,0x1b,0x18,0x3c,0x18,0x18,0xd8,0x70,
        0x1c,0x00,0x78,0x0c,0x7c,0xcc,0x7e,0x00,
        0x38,0x00,0x70,0x30,0x30,0x30,0x78,0x00,
        0x00,0x1c,0x00,0x78,0xcc,0xcc,0x78,0x00,
        0x00,0x1c,0x00,0xcc,0xcc,0xcc,0x7e,0x00,
        0x00,0xf8,0x00,0xf8,0xcc,0xcc,0xcc,0x00,
        0xfc,0x00,0xcc,0xec,0xfc,0xdc,0xcc,0x00,
        0x3c,0x6c,0x6c,0x3e,0x00,0x7e,0x00,0x00,
        0x38,0x6c,0x6c,0x38,0x00,0x7c,0x00,0x00,
        0x30,0x00,0x30,0x60,0xc0,0xcc,0x78,0x00,
        0x00,0x00,0x00,0xfc,0xc0,0xc0,0x00,0x00,
        0x00,0x00,0x00,0xfc,0x0c,0x0c,0x00,0x00,
        0xc3,0xc6,0xcc,0xde,0x33,0x66,0xcc,0x0f,
        0xc3,0xc6,0xcc,0xdb,0x37,0x6f,0xcf,0x03,
        0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x00,
        0x00,0x33,0x66,0xcc,0x66,0x33,0x00,0x00,
        0x00,0xcc,0x66,0x33,0x66,0xcc,0x00,0x00,
        0x22,0x88,0x22,0x88,0x22,0x88,0x22,0x88,
        0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,
        0xdb,0x77,0xdb,0xee,0xdb,0x77,0xdb,0xee,
        0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0xf8,0x18,0x18,0x18,
        0x18,0x18,0xf8,0x18,0xf8,0x18,0x18,0x18,
        0x36,0x36,0x36,0x36,0xf6,0x36,0x36,0x36,
        0x00,0x00,0x00,0x00,0xfe,0x36,0x36,0x36,
        0x00,0x00,0xf8,0x18,0xf8,0x18,0x18,0x18,
        0x36,0x36,0xf6,0x06,0xf6,0x36,0x36,0x36,
        0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
        0x00,0x00,0xfe,0x06,0xf6,0x36,0x36,0x36,
        0x36,0x36,0xf6,0x06,0xfe,0x00,0x00,0x00,
        0x36,0x36,0x36,0x36,0xfe,0x00,0x00,0x00,
        0x18,0x18,0xf8,0x18,0xf8,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0xf8,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x1f,0x00,0x00,0x00,
        0x18,0x18,0x18,0x18,0xff,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0xff,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x1f,0x18,0x18,0x18,
        0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,
        0x18,0x18,0x18,0x18,0xff,0x18,0x18,0x18,
        0x18,0x18,0x1f,0x18,0x1f,0x18,0x18,0x18,
        0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,
        0x36,0x36,0x37,0x30,0x3f,0x00,0x00,0x00,
        0x00,0x00,0x3f,0x30,0x37,0x36,0x36,0x36,
        0x36,0x36,0xf7,0x00,0xff,0x00,0x00,0x00,
        0x00,0x00,0xff,0x00,0xf7,0x36,0x36,0x36,
        0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36,
        0x00,0x00,0xff,0x00,0xff,0x00,0x00,0x00,
        0x36,0x36,0xf7,0x00,0xf7,0x36,0x36,0x36,
        0x18,0x18,0xff,0x00,0xff,0x00,0x00,0x00,
        0x36,0x36,0x36,0x36,0xff,0x00,0x00,0x00,
        0x00,0x00,0xff,0x00,0xff,0x18,0x18,0x18,
        0x00,0x00,0x00,0x00,0xff,0x36,0x36,0x36,
        0x36,0x36,0x36,0x36,0x3f,0x00,0x00,0x00,
        0x18,0x18,0x1f,0x18,0x1f,0x00,0x00,0x00,
        0x00,0x00,0x1f,0x18,0x1f,0x18,0x18,0x18,
        0x00,0x00,0x00,0x00,0x3f,0x36,0x36,0x36,
        0x36,0x36,0x36,0x36,0xff,0x36,0x36,0x36,
        0x18,0x18,0xff,0x18,0xff,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0xf8,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x1f,0x18,0x18,0x18,
        0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
        0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,
        0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,
        0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
        0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
        0x00,0x00,0x76,0xdc,0xc8,0xdc,0x76,0x00,
        0x00,0x78,0xcc,0xf8,0xcc,0xf8,0xc0,0xc0,
        0x00,0xfc,0xcc,0xc0,0xc0,0xc0,0xc0,0x00,
        0x00,0xfe,0x6c,0x6c,0x6c,0x6c,0x6c,0x00,
        0xfc,0xcc,0x60,0x30,0x60,0xcc,0xfc,0x00,
        0x00,0x00,0x7e,0xd8,0xd8,0xd8,0x70,0x00,
        0x00,0x66,0x66,0x66,0x66,0x7c,0x60,0xc0,
        0x00,0x76,0xdc,0x18,0x18,0x18,0x18,0x00,
        0xfc,0x30,0x78,0xcc,0xcc,0x78,0x30,0xfc,
        0x38,0x6c,0xc6,0xfe,0xc6,0x6c,0x38,0x00,
        0x38,0x6c,0xc6,0xc6,0x6c,0x6c,0xee,0x00,
        0x1c,0x30,0x18,0x7c,0xcc,0xcc,0x78,0x00,
        0x00,0x00,0x7e,0xdb,0xdb,0x7e,0x00,0x00,
        0x06,0x0c,0x7e,0xdb,0xdb,0x7e,0x60,0xc0,
        0x38,0x60,0xc0,0xf8,0xc0,0x60,0x38,0x00,
        0x78,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0x00,
        0x00,0xfc,0x00,0xfc,0x00,0xfc,0x00,0x00,
        0x30,0x30,0xfc,0x30,0x30,0x00,0xfc,0x00,
        0x60,0x30,0x18,0x30,0x60,0x00,0xfc,0x00,
        0x18,0x30,0x60,0x30,0x18,0x00,0xfc,0x00,
        0x0e,0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,
        0x18,0x18,0x18,0x18,0x18,0xd8,0xd8,0x70,
        0x30,0x30,0x00,0xfc,0x00,0x30,0x30,0x00,
        0x00,0x76,0xdc,0x00,0x76,0xdc,0x00,0x00,
        0x38,0x6c,0x6c,0x38,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
        0x0f,0x0c,0x0c,0x0c,0xec,0x6c,0x3c,0x1c,
        0x78,0x6c,0x6c,0x6c,0x6c,0x00,0x00,0x00,
        0x70,0x18,0x30,0x60,0x78,0x00,0x00,0x00,
        0x00,0x00,0x3c,0x3c,0x3c,0x3c,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    };

static uint32 videoCursor = 0;
static uint16 * videoBuffer = 0;

void Draw(uint8 c)
{
    if (videoBuffer == NULL) {
        return;
    }

    if (c == '\f') {
        videoCursor = 0;
        memset(videoBuffer, 0, 240 * 320 * 2);
        return;
    }
    else if (c == '\n') {
        videoCursor += 30 - (videoCursor % 30);
      check_scroll:
        while (videoCursor >= 30 * 40) {
            memmove(videoBuffer, videoBuffer + 240 * 8, 240 * 312 * 2);
            memset(videoBuffer + 312 * 240, 0, 240 * 16);    // 2 bytes/pixel * 8 pixels
            videoCursor -= 30;
        }
        return;
    }

    uint cy = (videoCursor / 30) * 8;
    uint cx = (videoCursor % 30) * 8;
    uint16 * buffer = videoBuffer + 240 * cy + cx;

    if (c == '\r') {
        uint toclear = 30 - (videoCursor % 30);

        for (uint y = 0; y < 8; y++) {
            memset(buffer, 0, toclear * 16);    // 2 bytes/pixel * 8 pixels
            buffer += 240;
        }
        videoCursor -= videoCursor % 30;
        return;
    }

    // Find the glyph.
    uint8 *pixels = Font8 + c * 8;

    // Draw the pixels.
    for (uint y = 0; y < 8; y++) {
        uint8 line = *pixels++;
        for (int x = 7; x >= 0; x--) {
            buffer[x] = (line & 1) ? 0xf800 : 0x0000;
            line >>= 1;
        }
        buffer += 240;
    }
    videoCursor++;
    goto check_scroll;
}

void Draw(const char * str)
{
    for (int i = 0; i < 2048 && str[i] != '\0'; i++) {
        Draw((uint8)str[i]);
    }
}

//////////////////////////////////////////////////////////////////////////////

void Halt()
{
    printf("Halt.");
    for (;;);
}

void __cdecl PutChar(char cOut)
{
    Draw(cOut);

    static CHAR szBuffer[256];
    static INT nBuffer = 0;

    szBuffer[nBuffer++] = cOut;
    if (cOut == '\n' || nBuffer >= sizeof(szBuffer) - 1) {
        BdPrintString(szBuffer, nBuffer);
        nBuffer = 0;
    }
}

//////////////////////////////////////////////////////////////////////////////
//
extern "C"
void KernelEntry(Class_Microsoft_Singularity_Hal_Platform *bi,
                Class_Microsoft_Singularity_Hal_Cpu *ci)
{
    videoBuffer = (uint16 *)bi->IsaCsns;
    videoCursor = bi->IsaReadPort;

    BdInitDebugger(BdPortInit((uint32 *)OMAP_UART1_BASE, 115200));

    printf("\n\rFake Singularity ARM Kernel\n[" __DATE__ " "__TIME__ "]\n\r");
    bi->IsaReadPort = videoCursor;
    bi->KillAction = 0x0001;
}
